/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.test;

import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.ws.api.WSBindingInput;
import filenet.ws.api.WSBindingOperation;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSMIMEPart;
import filenet.ws.api.WSPort;
import filenet.ws.api.test.ByteArrayDataSource;
import filenet.ws.listener.axis.SOAPMessageUtils;
import filenet.ws.utils.P8BPMSoapActionURI;
import filenet.ws.utils.att.AttachmentHelper;
import filenet.ws.utils.att.IWSAttSaver;
import filenet.ws.utils.att.IWSAttSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPEnvelope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InvokeTest {
    private static SOAPMessage callAxis(SOAPConnection connection, SOAPMessage request, String endPoint) throws Exception {
        try {
            String[] soapActionURIs;
            Call call = new Call(endPoint);
            ((Message)request).setMessageContext(call.getMessageContext());
            SOAPEnvelope env = ((Message)request).getSOAPEnvelope();
            Attachments attachments = ((Message)request).getAttachmentsImpl();
            if (attachments != null) {
                for (Object attachment : attachments.getAttachments()) {
                    call.addAttachmentPart(attachment);
                }
            }
            call.setTimeout(new Integer(300000));
            call.setReturnClass(SOAPMessage.class);
            MimeHeaders headers = request.getMimeHeaders();
            if (headers != null && (soapActionURIs = request.getMimeHeaders().getHeader("SOAPAction")) != null) {
                call.setUseSOAPAction(true);
                String soapActionURI = soapActionURIs[0];
                call.setSOAPActionURI(soapActionURI);
            }
            call.invoke(env);
            return call.getResponseMessage();
        }
        catch (MalformedURLException mue) {
            throw new SOAPException((Throwable)mue);
        }
        catch (AxisFault af) {
            throw new SOAPException((Throwable)af);
        }
        catch (RemoteException re) {
            throw new SOAPException((Throwable)re);
        }
    }

    public static void testRPCFromFile() throws Exception {
    }

    public static void testDocLiteralFromFileBlock() throws Exception {
        String inFile = "f:\\delme\\ws\\ws.xml";
        String outFile = "f:\\delme\\ws\\outData.xml";
        StringBuffer buf = new StringBuffer();
        String serverURL = "http://localhost:5050/Workplace/P8BPMWSBroker/services/MessageService";
        String s = "~~1\tabc\t3\t5\t7\t0";
        P8BPMSoapActionURI soapURI = new P8BPMSoapActionURI();
        soapURI.setVWVersion(s);
        soapURI.setPortType("myPortType");
        soapURI.setOperation("myOperation");
        soapURI.addExtensibleItem("blocked");
        String soapAction = soapURI.toStringEx();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:tns=\"http://www.instantlogic.com/\" xmlns:types=\"http://www.instantlogic.com/encodedTypes\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        buf.append("<soap:Body soap:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        buf.append("<tns:ZipCodes>");
        buf.append("<Zip xsi:type=\"xsd:string\">92708</Zip>");
        buf.append("</tns:ZipCodes>");
        buf.append("</soap:Body></soap:Envelope>");
        SOAPConnectionFactory scFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = scFactory.createConnection();
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(buf.toString().getBytes("UTF-8")));
        message.getMimeHeaders().addHeader("SOAPAction", soapAction);
        message.writeTo((OutputStream)System.out);
        String endpoint = serverURL;
        SOAPMessage response = InvokeTest.callAxis(connection, message, endpoint);
        SOAPBody responseBody = response.getSOAPPart().getEnvelope().getBody();
        if (responseBody.hasFault()) {
            System.out.println("\nhas faultCode=" + responseBody.getFault().getFaultCode());
        } else {
            System.out.println("\n" + responseBody.toString());
            Iterator iter = responseBody.getChildElements();
            if (iter.hasNext()) {
                SOAPBodyElement bodyElement = (SOAPBodyElement)iter.next();
                System.out.println("\nbody Element = " + bodyElement.toString());
                Iterator iter2 = bodyElement.getChildElements();
                while (iter2.hasNext()) {
                    System.out.println("\n child Element = " + iter2.next().toString());
                }
            }
        }
        System.out.println("RESPONSE=");
        response.writeTo((OutputStream)System.out);
    }

    public static void testDocLiteralFromFileUnblock() throws Exception {
        String inFile = "f:\\delme\\ws\\ws.xml";
        String outFile = "f:\\delme\\ws\\outData.xml";
        StringBuffer buf = new StringBuffer();
        String serverURL = "http://localhost:5050/Workplace/P8BPMWSBroker/services/MessageService";
        String s = "~~1\tabc\t3\t5\t7\t0";
        P8BPMSoapActionURI soapURI = new P8BPMSoapActionURI();
        soapURI.setVWVersion(s);
        soapURI.setPortType("myPortType");
        soapURI.setOperation("myOperation");
        soapURI.addExtensibleItem("blocked");
        soapURI.addExtensibleItem("C1");
        String soapAction = soapURI.toStringEx();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:tns=\"http://www.instantlogic.com/\" xmlns:types=\"http://www.instantlogic.com/encodedTypes\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        buf.append("<soap:Body soap:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        buf.append("<tns:ZipCodes>");
        buf.append("<Zip xsi:type=\"xsd:string\">9999999999999999</Zip>");
        buf.append("</tns:ZipCodes>");
        buf.append("</soap:Body></soap:Envelope>");
        SOAPConnectionFactory scFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = scFactory.createConnection();
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(buf.toString().getBytes("UTF-8")));
        message.getMimeHeaders().addHeader("SOAPAction", soapAction);
        message.writeTo((OutputStream)System.out);
        String endpoint = serverURL;
        SOAPMessage response = InvokeTest.callAxis(connection, message, endpoint);
        SOAPBody responseBody = response.getSOAPPart().getEnvelope().getBody();
        if (responseBody.hasFault()) {
            System.out.println("\nhas faultCode=" + responseBody.getFault().getFaultCode());
        } else {
            System.out.println("\n" + responseBody.toString());
            Iterator iter = responseBody.getChildElements();
            if (iter.hasNext()) {
                SOAPBodyElement bodyElement = (SOAPBodyElement)iter.next();
                System.out.println("\nbody Element = " + bodyElement.toString());
                Iterator iter2 = bodyElement.getChildElements();
                while (iter2.hasNext()) {
                    System.out.println("\n child Element = " + iter2.next().toString());
                }
            }
        }
        System.out.println("RESPONSE=");
        response.writeTo((OutputStream)System.out);
    }

    public static void testDocLiteralFromFileEx() throws Exception {
        String serverURL = "http://www.xignite.com/xsecurity.asmx?WSDL";
        String soapAction = "http://www.xignite.com/services/Lookup";
        String inFile = "f:\\delme\\ws\\ws.xml";
        String outFile = "f:\\delme\\ws\\outData.xml";
        SOAPConnectionFactory scFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = scFactory.createConnection();
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage();
        message.getMimeHeaders().addHeader("SOAPAction", soapAction);
        TransformerFactory tFact = TransformerFactory.newInstance();
        Transformer transformer = tFact.newTransformer();
        SOAPPart soapPart = message.getSOAPPart();
        javax.xml.soap.SOAPEnvelope envelope = soapPart.getEnvelope();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        String m_dataFileName = "f:\\delme\\ws\\wsin.xml";
        Document poDoc = db.parse(m_dataFileName);
        Source spSrc = soapPart.getContent();
        DOMResult domResultEnv = new DOMResult();
        transformer.transform(spSrc, domResultEnv);
        Node envelopeRoot = domResultEnv.getNode();
        if (envelopeRoot.getNodeType() == 9) {
            Element docEl = ((Document)envelopeRoot).getDocumentElement();
            NodeList nList = docEl.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (nList.getLength() > 0) {
                Node bodyNode = nList.item(0);
                Element poRoot = poDoc.getDocumentElement();
                Node importedNode = ((Document)envelopeRoot).importNode(poRoot, true);
                bodyNode.appendChild(importedNode);
                DOMSource domSource = new DOMSource(envelopeRoot);
                soapPart.setContent((Source)domSource);
            }
        } else if (envelopeRoot.getNodeType() == 1) {
            System.out.println("ElementNode");
        } else {
            System.out.println("Unknown Node type");
        }
        message.writeTo((OutputStream)System.out);
        SOAPMessage response = InvokeTest.callAxis(connection, message, serverURL);
        SOAPBody responseBody = response.getSOAPPart().getEnvelope().getBody();
        if (responseBody.hasFault()) {
            System.out.println("has faultCode=" + responseBody.getFault().getFaultCode());
        } else {
            System.out.println(responseBody.toString());
            Iterator iter = responseBody.getChildElements();
            while (iter.hasNext()) {
                SOAPBodyElement bodyElement = (SOAPBodyElement)iter.next();
                System.out.println("body Element = " + bodyElement.getValue());
                Iterator it2 = bodyElement.getChildElements();
                while (it2.hasNext()) {
                    SOAPElement element2 = (SOAPElement)it2.next();
                    System.out.println("element2 = " + element2.getValue());
                }
            }
        }
        System.out.println("RESPONSE=");
        response.writeTo((OutputStream)System.out);
    }

    private static String[] getNameSpaces(WSDefinition def) {
        Vector<String> v = new Vector<String>(5);
        v.add(" xmlns:e=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        v.add(" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\"");
        if (def != null) {
            String[] s = def.getNameSpaces();
            String xsd = null;
            for (int i = 0; i < s.length; ++i) {
                if (s[i].indexOf("w3.org") == -1 || s[i].indexOf("XMLSchema") == -1) continue;
                xsd = s[i];
            }
            if (xsd != null) {
                v.add(" xmlns:" + def.getNamespacePrefix(xsd) + "=\"" + xsd + "\"");
            } else {
                v.add(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
                xsd = "http://www.w3.org/2001/XMLSchema";
            }
            v.add(" xmlns:xsi=\"" + xsd + "-instance\"");
            v.add(" xmlns:tns=\"" + def.getTargetNameSpace() + "\"");
        }
        return v.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testAttachmentOld() throws Exception {
        String serverURL = "http://10.15.7.160:5050/demo/advanced/MIMEService/wsdl";
        String soapAddress = "http://10.15.7.160:5050/demo/advanced/MIMEService";
        String m_portType = "AttachmentsService";
        String m_op = "compress";
        WSDefinition m_definition = new WSDefinition(serverURL);
        WSPort m_port = m_definition.getDefaultPort(m_portType);
        WSBindingOperation SOAPOp = m_port.getBindingOperation(m_op);
        String soapAction = "";
        if (SOAPOp == null) {
            throw new Exception("no SOAP!");
        }
        if (SOAPOp.isSoapBinding()) {
            soapAction = SOAPOp.getSoapAction();
        }
        String soapStyle = SOAPOp.getSoapStyle();
        boolean isDocument = soapStyle.equals("document");
        String[] namespaces = InvokeTest.getNameSpaces(m_definition);
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version='1.0' encoding='UTF-8'?><e:Envelope ");
        if (namespaces != null) {
            int nNS = namespaces.length;
            for (int i = 0; i < nNS; ++i) {
                buf.append(namespaces[i]);
            }
        }
        buf.append("><e:Body>");
        WSBindingInput bindingInput = SOAPOp.getBindingInput();
        WSMIMEPart[] mimeParts = null;
        if (bindingInput != null && ((mimeParts = bindingInput.getMimeParts()) == null || mimeParts.length == 0)) {
            System.out.println("got out of here..");
            return;
        }
        String href = "123456";
        buf.append("<p0 xmlns=\"http://systinet.com/xsd/SchemaTypes/\" href=\"cid:").append(href).append("\"></p0>");
        buf.append("</e:Body></e:Envelope>");
        SOAPConnectionFactory scFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = scFactory.createConnection();
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(buf.toString().getBytes("UTF-8")));
        message.getMimeHeaders().addHeader("SOAPAction", soapAction);
        String testData = "this is a test to see if you can read this.  OK, this is a very long test, OK..";
        byte[] byteData = testData.getBytes();
        AttachmentPart attach = message.createAttachmentPart();
        attach.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource("Test Data", byteData, "application/binary")));
        attach.setContentId(href);
        message.addAttachmentPart(attach);
        message.writeTo((OutputStream)System.out);
        SOAPMessage response = InvokeTest.callAxis(connection, message, soapAddress);
        SOAPBody responseBody = response.getSOAPPart().getEnvelope().getBody();
        if (responseBody.hasFault()) {
            System.out.println("\nhas faultCode=" + responseBody.getFault().getFaultCode());
        } else {
            System.out.println("\n" + responseBody.toString());
            SOAPMessageUtils.exploreMessage(response);
            System.out.println("-------------------------------");
            Hashtable t1 = new Hashtable(1);
            Hashtable t2 = new Hashtable(1);
            SOAPMessageUtils.inspectAttribute((SOAPElement)responseBody, t1, t2, "href");
            Enumeration enum1 = t1.keys();
            while (enum1.hasMoreElements()) {
                String k = (String)enum1.nextElement();
                SOAPElement elk = (SOAPElement)t1.get(k);
                Name kn = (Name)t2.get(k);
                elk.removeAttribute(kn);
                elk.addAttribute(kn, "NEW ME!!?");
            }
            System.out.println("\nNEW BODY???" + responseBody.toString());
            System.out.println("-------------------------------");
            System.out.println("-------------------------------");
            int nAttachments = response.countAttachments();
            System.out.println("Response has " + nAttachments + " attachments");
            Iterator attIter = response.getAttachments();
            if (attIter != null && attIter.hasNext()) {
                System.out.println("!!!GOT ATTACHMENTS!!!");
                while (attIter.hasNext()) {
                    AttachmentPart att = (AttachmentPart)attIter.next();
                    System.out.println("Att " + att.getContentId() + ", type=" + att.getContentType());
                    InputStream is = att.getDataHandler().getInputStream();
                    ByteArrayOutputStream obs = null;
                    try {
                        obs = new ByteArrayOutputStream();
                        byte[] buff = new byte[1024];
                        int read = 0;
                        while ((read = is.read(buff, 0, buff.length)) != -1) {
                            obs.write(buff, 0, read);
                        }
                        byte[] compressedData = obs.toByteArray();
                    }
                    catch (Exception e) {
                        System.out.println("ExceptioN!!! " + e.getMessage());
                        e.printStackTrace();
                    }
                    finally {
                        if (obs != null) {
                            obs.close();
                        }
                    }
                }
            }
        }
        System.out.println("RESPONSE=");
        response.writeTo((OutputStream)System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testAttachment(String username, String pw, String configFile, String folder, String library) throws Exception {
        String serverURL = "http://10.15.7.160:5050/demo/advanced/MIMEService/wsdl";
        String soapAddress = "http://10.15.7.160:5050/demo/advanced/MIMEService";
        String m_portType = "AttachmentsService";
        String m_op = "compress";
        WSDefinition m_definition = new WSDefinition(serverURL);
        WSPort m_port = m_definition.getDefaultPort(m_portType);
        WSBindingOperation SOAPOp = m_port.getBindingOperation(m_op);
        String soapAction = "";
        if (SOAPOp == null) {
            throw new Exception("no SOAP!");
        }
        if (SOAPOp.isSoapBinding()) {
            soapAction = SOAPOp.getSoapAction();
        }
        String soapStyle = SOAPOp.getSoapStyle();
        boolean isDocument = soapStyle.equals("document");
        String[] namespaces = InvokeTest.getNameSpaces(m_definition);
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version='1.0' encoding='UTF-8'?><e:Envelope ");
        if (namespaces != null) {
            int nNS = namespaces.length;
            for (int i = 0; i < nNS; ++i) {
                buf.append(namespaces[i]);
            }
        }
        buf.append("><e:Body>");
        WSBindingInput bindingInput = SOAPOp.getBindingInput();
        WSMIMEPart[] mimeParts = null;
        if (bindingInput != null && ((mimeParts = bindingInput.getMimeParts()) == null || mimeParts.length == 0)) {
            System.out.println("got out of here..");
            return;
        }
        String href = "123456";
        buf.append("<p0 xmlns=\"http://systinet.com/xsd/SchemaTypes/\" href=\"cid:").append(href).append("\"></p0>");
        buf.append("</e:Body></e:Envelope>");
        SOAPConnectionFactory scFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = scFactory.createConnection();
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(buf.toString().getBytes("UTF-8")));
        message.getMimeHeaders().addHeader("SOAPAction", soapAction);
        String testData = "this is a test to see if you can read this.  OK, this is a very long test, OK..";
        byte[] byteData = testData.getBytes();
        AttachmentPart attach = message.createAttachmentPart();
        attach.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource("Test Data", byteData, "application/binary")));
        attach.setContentId(href);
        message.addAttachmentPart(attach);
        message.writeTo((OutputStream)System.out);
        SOAPMessage response = InvokeTest.callAxis(connection, message, soapAddress);
        SOAPBody responseBody = response.getSOAPPart().getEnvelope().getBody();
        if (responseBody.hasFault()) {
            System.out.println("\nhas faultCode=" + responseBody.getFault().getFaultCode());
        } else {
            System.out.println("\n" + responseBody.toString());
            SOAPMessageUtils.exploreMessage(response);
            System.out.println("-------------------------------");
            System.out.println("\nNEW BODY???" + responseBody.toString());
            System.out.println("-------------------------------");
            System.out.println("-------------------------------");
            int nAttachments = response.countAttachments();
            System.out.println("Response has " + nAttachments + " attachments");
            Iterator attIter = response.getAttachments();
            if (attIter != null && attIter.hasNext()) {
                System.out.println("!!!GOT ATTACHMENTS!!!");
                while (attIter.hasNext()) {
                    AttachmentPart att = (AttachmentPart)attIter.next();
                    System.out.println("Att " + att.getContentId() + ", type=" + att.getContentType());
                    if (username != null && pw != null && configFile != null && folder != null && library != null) {
                        String handlerClassName = "filenet.vw.idm.trident.WSSession";
                        Class<?> handlerClass = Class.forName(handlerClassName);
                        IWSAttSession m_gWSAttSession = (IWSAttSession)handlerClass.newInstance();
                        m_gWSAttSession.setCredentials(username, pw, new File(configFile));
                        IWSAttSaver saver = m_gWSAttSession.getSaver(library, folder);
                        String titlePrefix = "QTEST";
                        String newInMsg = AttachmentHelper.storeAttachments(response, saver, titlePrefix, null);
                        System.out.println(">>>>");
                        System.out.println(newInMsg);
                        System.out.println("<<<<");
                        continue;
                    }
                    InputStream is = att.getDataHandler().getInputStream();
                    ByteArrayOutputStream obs = null;
                    try {
                        obs = new ByteArrayOutputStream();
                        byte[] buff = new byte[1024];
                        int read = 0;
                        while ((read = is.read(buff, 0, buff.length)) != -1) {
                            obs.write(buff, 0, read);
                        }
                        byte[] compressedData = obs.toByteArray();
                    }
                    catch (Exception e) {
                        System.out.println("ExceptioN!!! " + e.getMessage());
                        e.printStackTrace();
                    }
                    finally {
                        if (obs != null) {
                            obs.close();
                        }
                    }
                }
            }
        }
        System.out.println("RESPONSE=");
        response.writeTo((OutputStream)System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testDecompressAttachment(byte[] byteData) throws Exception {
        String serverURL = "http://10.15.7.160:5050/demo/advanced/MIMEService/wsdl";
        String soapAddress = "http://10.15.7.160:5050/demo/advanced/MIMEService";
        String m_portType = "AttachmentsService";
        String m_op = "decompress";
        WSDefinition m_definition = new WSDefinition(serverURL);
        WSPort m_port = m_definition.getDefaultPort(m_portType);
        WSBindingOperation SOAPOp = m_port.getBindingOperation(m_op);
        String soapAction = "";
        if (SOAPOp == null) {
            throw new Exception("no SOAP!");
        }
        if (SOAPOp.isSoapBinding()) {
            soapAction = SOAPOp.getSoapAction();
        }
        String soapStyle = SOAPOp.getSoapStyle();
        boolean isDocument = soapStyle.equals("document");
        String[] namespaces = InvokeTest.getNameSpaces(m_definition);
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version='1.0' encoding='UTF-8'?><e:Envelope ");
        if (namespaces != null) {
            int nNS = namespaces.length;
            for (int i = 0; i < nNS; ++i) {
                buf.append(namespaces[i]);
            }
        }
        buf.append("><e:Body>");
        WSBindingInput bindingInput = SOAPOp.getBindingInput();
        WSMIMEPart[] mimeParts = null;
        if (bindingInput != null && ((mimeParts = bindingInput.getMimeParts()) == null || mimeParts.length == 0)) {
            System.out.println("got out of here..");
            return;
        }
        String href = "123456";
        buf.append("<p0 xmlns=\"http://systinet.com/xsd/SchemaTypes/\" href=\"cid:").append(href).append("\"></p0>");
        buf.append("</e:Body></e:Envelope>");
        SOAPConnectionFactory scFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = scFactory.createConnection();
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(buf.toString().getBytes("UTF-8")));
        message.getMimeHeaders().addHeader("SOAPAction", soapAction);
        AttachmentPart attach = message.createAttachmentPart();
        attach.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource("Test Data", byteData, "application/binary")));
        attach.setContentId(href);
        message.addAttachmentPart(attach);
        message.writeTo((OutputStream)System.out);
        SOAPMessage response = InvokeTest.callAxis(connection, message, soapAddress);
        SOAPBody responseBody = response.getSOAPPart().getEnvelope().getBody();
        if (responseBody.hasFault()) {
            System.out.println("\nhas faultCode=" + responseBody.getFault().getFaultCode());
        } else {
            Iterator attIter;
            System.out.println("\n" + responseBody.toString());
            Iterator iter = responseBody.getChildElements();
            if (iter.hasNext()) {
                SOAPBodyElement bodyElement = (SOAPBodyElement)iter.next();
                System.out.println("\nbody Element = " + bodyElement.toString());
                Iterator iter2 = bodyElement.getChildElements();
                while (iter2.hasNext()) {
                    System.out.println("\n child Element = " + iter2.next().toString());
                }
            }
            if ((attIter = response.getAttachments()) != null && attIter.hasNext()) {
                System.out.println("!!!GOT DECOMPRESSED ATTACHMENTS!!!");
                while (attIter.hasNext()) {
                    AttachmentPart att = (AttachmentPart)attIter.next();
                    System.out.println("Att " + att.getContentId() + ", type=" + att.getContentType());
                    InputStream is = att.getDataHandler().getInputStream();
                    ByteArrayOutputStream obs = null;
                    try {
                        obs = new ByteArrayOutputStream();
                        byte[] buff = new byte[1024];
                        int read = 0;
                        while ((read = is.read(buff, 0, buff.length)) != -1) {
                            obs.write(buff, 0, read);
                        }
                        byte[] compressedData = obs.toByteArray();
                        String s = new String(compressedData);
                        System.out.println("DECOMPRESS = " + s);
                    }
                    catch (Exception e) {
                        System.out.println("ExceptioN!!! " + e.getMessage());
                        e.printStackTrace();
                    }
                    finally {
                        if (obs != null) {
                            obs.close();
                        }
                    }
                }
            }
        }
        System.out.println("RESPONSE=");
        response.writeTo((OutputStream)System.out);
    }

    public static void main(String[] args) throws Exception {
        try {
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            InvokeTest.testAttachment(c.getParameter("user"), c.getParameter("pw"), c.getParameter("configFile"), c.getParameter("folder"), c.getParameter("library"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

